/* ------------------------------------------------------------------------------
  File: chr6d_packet_handler.h
  Author: CH Robotics
  Version: 1.0
  
  Description: Definitions used for handling packets.
------------------------------------------------------------------------------ */ 
#ifndef __CHR6D_PACKET_HANDLER_H
#define __CHR6D_PACKET_HANDLER_H

#include "CHR_matrix.h"
#include "UM6_usart.h"
#include "UM6_startup.h"
#include "UM6_states.h"

void ProcessPacket( USARTPacket* new_packet );
void DispatchPacket( USARTPacket* new_packet );

void SendCommandSuccessPacket( uint8_t command );
void SendCommandFailedPacket( uint8_t command );

void SendDataPacket( );
void SendGlobalData(uint8_t address, uint8_t address_type, uint8_t is_batch, uint8_t batch_length);

void SendStatusPacket();

void PackageMatrixForTransmit( USARTPacket* packet, fMatrix* matrix );

// Global data buffers defined in main.c

extern RawSensorData gSensorData;
extern AHRS_state_data gEstimatedStates;

#endif
